<?php
require_once 'config.php';

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

switch ($method) {
    case 'GET':
        $clients = readJsonFile('clients.json');
        
        if (isset($_GET['id'])) {
            $client = array_filter($clients, fn($c) => $c['id'] === $_GET['id']);
            $client = array_values($client);
            sendResponse($client ? $client[0] : null);
        } else {
            sendResponse($clients);
        }
        break;

    case 'POST':
        $error = validateFields($input, ['name']);
        if ($error) sendError($error);

        $clients = readJsonFile('clients.json');
        $input['id'] = generateId('c');
        
        $clients[] = $input;
        
        if (writeJsonFile('clients.json', $clients)) {
            sendResponse($input, 201);
        } else {
            sendError('Failed to create client', 500);
        }
        break;

    case 'PUT':
        if (!isset($input['id'])) sendError('Client ID is required');
        
        $clients = readJsonFile('clients.json');
        $found = false;
        
        foreach ($clients as $key => $client) {
            if ($client['id'] === $input['id']) {
                $clients[$key] = array_merge($client, $input);
                $found = true;
                break;
            }
        }
        
        if (!$found) sendError('Client not found', 404);
        
        if (writeJsonFile('clients.json', $clients)) {
            sendResponse($clients[$key]);
        } else {
            sendError('Failed to update client', 500);
        }
        break;

    case 'DELETE':
        if (!isset($_GET['id'])) sendError('Client ID is required');
        
        $clients = readJsonFile('clients.json');
        $filtered = array_filter($clients, fn($c) => $c['id'] !== $_GET['id']);
        
        if (count($filtered) === count($clients)) {
            sendError('Client not found', 404);
        }
        
        if (writeJsonFile('clients.json', array_values($filtered))) {
            sendResponse(['success' => true, 'message' => 'Client deleted']);
        } else {
            sendError('Failed to delete client', 500);
        }
        break;

    default:
        sendError('Method not allowed', 405);
}
?>
