<?php
require_once 'config.php';

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

switch ($method) {
    case 'GET':
        $content = readJsonFile('content.json');
        // Return empty object if not found, frontend handles defaults
        sendResponse($content ?: new stdClass());
        break;

    case 'POST':
        if (writeJsonFile('content.json', $input)) {
            sendResponse($input);
        } else {
            sendError('Failed to save content', 500);
        }
        break;

    default:
        sendError('Method not allowed', 405);
}
?>
