<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendError('Only POST method is allowed', 405);
}

$input = json_decode(file_get_contents('php://input'), true);

if (!isset($input['filePath'])) {
    sendError('File path is required');
}

$filePath = $input['filePath'];

// Security check: Ensure path is within uploads directory and not traversing up
// The filePath from frontend might be full URL or relative path. 
// We expect relative path like /api/uploads/images/filename.ext or uploads/images/filename.ext

// Remove /api/ prefix if present
$relativePath = str_replace('/api/', '', $filePath);
// Remove leading slash
$relativePath = ltrim($relativePath, '/');

// Construct full path
$fullPath = __DIR__ . '/' . $relativePath;

// Verify it is inside UPLOAD_DIR
$realUploadDir = realpath(UPLOAD_DIR);
$realFullPath = realpath($fullPath);

// If file doesn't exist, realpath returns false. 
// If it exists, we check if it starts with upload dir path.
if ($realFullPath && strpos($realFullPath, $realUploadDir) === 0) {
    if (unlink($realFullPath)) {
        sendResponse(['success' => true, 'message' => 'File deleted successfully']);
    } else {
        sendError('Failed to delete file', 500);
    }
} else {
    // File not found or security violation
    // We return success even if file not found to be idempotent, 
    // but for debugging let's return 404 if not found.
    if (!file_exists($fullPath)) {
        sendError('File not found', 404);
    } else {
        sendError('Invalid file path', 403);
    }
}
?>
