<?php
require_once 'config.php';

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

switch ($method) {
    case 'GET':
        $locations = readJsonFile('locations.json');
        sendResponse($locations);
        break;

    case 'POST':
        $error = validateFields($input, ['name', 'address']);
        if ($error) sendError($error);

        $locations = readJsonFile('locations.json');
        if (!isset($input['id'])) {
            $input['id'] = generateId('loc');
        }
        
        $locations[] = $input;
        
        if (writeJsonFile('locations.json', $locations)) {
            sendResponse($input, 201);
        } else {
            sendError('Failed to create location', 500);
        }
        break;

    case 'PUT':
        if (!isset($input['id'])) sendError('Location ID is required');
        
        $locations = readJsonFile('locations.json');
        $found = false;
        
        foreach ($locations as $key => $loc) {
            if ($loc['id'] === $input['id']) {
                $locations[$key] = array_merge($loc, $input);
                $found = true;
                break;
            }
        }
        
        if (!$found) sendError('Location not found', 404);
        
        if (writeJsonFile('locations.json', $locations)) {
            sendResponse($locations[$key]);
        } else {
            sendError('Failed to update location', 500);
        }
        break;

    case 'DELETE':
        if (!isset($_GET['id'])) sendError('Location ID is required');
        
        $locations = readJsonFile('locations.json');
        $initialCount = count($locations);
        $locations = array_filter($locations, fn($l) => $l['id'] !== $_GET['id']);
        
        if (count($locations) === $initialCount) {
            sendError('Location not found', 404);
        }
        
        if (writeJsonFile('locations.json', array_values($locations))) {
            sendResponse(['success' => true]);
        } else {
            sendError('Failed to delete location', 500);
        }
        break;

    default:
        sendError('Method not allowed', 405);
}
?>
