<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendError('Only POST method is allowed', 405);
}

$input = json_decode(file_get_contents('php://input'), true);
$error = validateFields($input, ['email', 'password']);
if ($error) sendError($error);

$users = readJsonFile('users.json');
$user = null;

foreach ($users as $u) {
    if ($u['email'] === $input['email']) {
        // In a real app, use password_verify. Here we compare directly as per current implementation style
        // Assuming passwords are stored as plain text for this specific project based on previous context, 
        // or if they are hashed, we should check. 
        // Let's assume simple comparison for now as I haven't seen password hashing in users.php
        if ($u['password'] === $input['password']) {
            $user = $u;
            break;
        }
    }
}

if ($user) {
    // Remove password from response
    unset($user['password']);
    sendResponse($user);
} else {
    sendError('Invalid email or password', 401);
}
?>
