<?php
require_once 'config.php';

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

// Handle different HTTP methods
switch ($method) {
    case 'GET':
        // Get all process steps
        $steps = readJsonFile('process_steps.json');
        sendResponse($steps);
        break;

    case 'POST':
        // Create new process step
        $error = validateFields($input, ['number', 'title', 'description']);
        if ($error) sendError($error);

        $steps = readJsonFile('process_steps.json');
        $input['id'] = generateId('step');
        
        $steps[] = $input;
        
        if (writeJsonFile('process_steps.json', $steps)) {
            sendResponse($input, 201);
        } else {
            sendError('Failed to create process step', 500);
        }
        break;

    case 'PUT':
        // Update existing process step
        if (!isset($input['id'])) sendError('Process step ID is required');
        
        $steps = readJsonFile('process_steps.json');
        $found = false;
        
        foreach ($steps as $key => $step) {
            if ($step['id'] === $input['id']) {
                $steps[$key] = array_merge($step, $input);
                $found = true;
                break;
            }
        }
        
        if (!$found) sendError('Process step not found', 404);
        
        if (writeJsonFile('process_steps.json', $steps)) {
            sendResponse($steps[$key]);
        } else {
            sendError('Failed to update process step', 500);
        }
        break;

    case 'DELETE':
        // Delete process step
        if (!isset($_GET['id'])) sendError('Process step ID is required');
        
        $steps = readJsonFile('process_steps.json');
        $filtered = array_filter($steps, fn($s) => $s['id'] !== $_GET['id']);
        
        if (count($filtered) === count($steps)) {
            sendError('Process step not found', 404);
        }
        
        if (writeJsonFile('process_steps.json', array_values($filtered))) {
            sendResponse(['success' => true, 'message' => 'Process step deleted']);
        } else {
            sendError('Failed to delete process step', 500);
        }
        break;

    default:
        sendError('Method not allowed', 405);
}
?>
