<?php
require_once 'email_config.php';

/**
 * Send email using PHP mail() function
 * For production, consider using PHPMailer or similar library
 */
function sendEmail($to, $subject, $htmlBody, $plainTextBody = '') {
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= "From: " . SMTP_FROM_NAME . " <" . SMTP_FROM_EMAIL . ">" . "\r\n";
    $headers .= "Reply-To: " . SMTP_FROM_EMAIL . "\r\n";
    
    // Send email
    $success = mail($to, $subject, $htmlBody, $headers);
    
    return $success;
}

/**
 * Send quotation confirmation email to customer
 */
function sendQuotationConfirmation($customerEmail, $customerName, $quotationId, $totalPrice) {
    $subject = "Quotation Request Received - PSS Survey Solutions";
    
    $htmlBody = "
    <!DOCTYPE html>
    <html>
    <head>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background-color: #0EA5E9; color: white; padding: 20px; text-align: center; }
            .content { padding: 20px; background-color: #f9f9f9; }
            .footer { padding: 20px; text-align: center; font-size: 12px; color: #666; }
            .button { display: inline-block; padding: 12px 24px; background-color: #0EA5E9; color: white; text-decoration: none; border-radius: 5px; margin: 10px 0; }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h1>Thank You for Your Quotation Request!</h1>
            </div>
            <div class='content'>
                <p>Dear {$customerName},</p>
                <p>We have received your quotation request and our team will review it shortly.</p>
                <p><strong>Quotation ID:</strong> {$quotationId}</p>
                <p><strong>Estimated Total:</strong> \${$totalPrice}</p>
                <p>Our team will contact you within 24-48 hours to discuss your requirements and provide a detailed quotation.</p>
                <p>If you have any immediate questions, please don't hesitate to contact us.</p>
                <a href='https://survey.pssbd.dev' class='button'>Visit Our Website</a>
            </div>
            <div class='footer'>
                <p>&copy; " . date('Y') . " PSS Survey Solutions. All rights reserved.</p>
                <p>This is an automated message. Please do not reply to this email.</p>
            </div>
        </div>
    </body>
    </html>
    ";
    
    return sendEmail($customerEmail, $subject, $htmlBody);
}

/**
 * Send survey inquiry confirmation email
 */
function sendInquiryConfirmation($customerEmail, $customerName, $inquiryId) {
    $subject = "Survey Inquiry Received - PSS Survey Solutions";
    
    $htmlBody = "
    <!DOCTYPE html>
    <html>
    <head>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background-color: #0EA5E9; color: white; padding: 20px; text-align: center; }
            .content { padding: 20px; background-color: #f9f9f9; }
            .footer { padding: 20px; text-align: center; font-size: 12px; color: #666; }
            .button { display: inline-block; padding: 12px 24px; background-color: #0EA5E9; color: white; text-decoration: none; border-radius: 5px; margin: 10px 0; }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h1>Thank You for Your Inquiry!</h1>
            </div>
            <div class='content'>
                <p>Dear {$customerName},</p>
                <p>We have received your survey inquiry and appreciate your interest in our services.</p>
                <p><strong>Inquiry ID:</strong> {$inquiryId}</p>
                <p>Our team will review your request and contact you shortly to discuss your survey requirements.</p>
                <p>We look forward to serving you!</p>
                <a href='https://survey.pssbd.dev' class='button'>Visit Our Website</a>
            </div>
            <div class='footer'>
                <p>&copy; " . date('Y') . " PSS Survey Solutions. All rights reserved.</p>
                <p>This is an automated message. Please do not reply to this email.</p>
            </div>
        </div>
    </body>
    </html>
    ";
    
    return sendEmail($customerEmail, $subject, $htmlBody);
}

/**
 * Notify admin of new quotation
 */
function notifyAdminNewQuotation($quotationId, $customerName, $customerEmail, $totalPrice) {
    $subject = "New Quotation Request - {$customerName}";
    
    $htmlBody = "
    <h2>New Quotation Request Received</h2>
    <p><strong>Quotation ID:</strong> {$quotationId}</p>
    <p><strong>Customer:</strong> {$customerName}</p>
    <p><strong>Email:</strong> {$customerEmail}</p>
    <p><strong>Total:</strong> \${$totalPrice}</p>
    <p>Please review and respond to this quotation request in the admin dashboard.</p>
    ";
    
    return sendEmail(ADMIN_EMAIL, $subject, $htmlBody);
}
?>
