<?php
require_once 'config.php';

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

switch ($method) {
    case 'GET':
        $settings = readJsonFile('settings.json');
        
        if (isset($_GET['key'])) {
            // Get specific setting by key
            $setting = $settings[$_GET['key']] ?? null;
            sendResponse(['key' => $_GET['key'], 'value' => $setting]);
        } else {
            // Get all settings
            sendResponse($settings);
        }
        break;

    case 'POST':
    case 'PUT':
        // Update settings (can update multiple at once)
        if (!is_array($input)) sendError('Settings must be an object');
        
        $settings = readJsonFile('settings.json');
        
        // Merge new settings with existing
        foreach ($input as $key => $value) {
            $settings[$key] = $value;
        }
        
        if (writeJsonFile('settings.json', $settings)) {
            sendResponse($settings);
        } else {
            sendError('Failed to update settings', 500);
        }
        break;

    case 'DELETE':
        if (!isset($_GET['key'])) sendError('Setting key is required');
        
        $settings = readJsonFile('settings.json');
        
        if (!isset($settings[$_GET['key']])) {
            sendError('Setting not found', 404);
        }
        
        unset($settings[$_GET['key']]);
        
        if (writeJsonFile('settings.json', $settings)) {
            sendResponse(['success' => true, 'message' => 'Setting deleted']);
        } else {
            sendError('Failed to delete setting', 500);
        }
        break;

    default:
        sendError('Method not allowed', 405);
}
?>
