<?php
require_once 'config.php';

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

switch ($method) {
    case 'GET':
        $team = readJsonFile('team.json');
        // Return default structure if empty
        if (empty($team)) {
            $team = [
                'id' => 'md',
                'name' => 'Managing Director',
                'role' => 'CEO',
                'children' => []
            ];
        }
        sendResponse($team);
        break;

    case 'POST':
        // For team, we usually update the entire structure or add a member
        // But since the frontend sends specific updates, we might need to handle it.
        // However, the simplest way for hierarchical data is to save the whole tree.
        // Let's support saving the whole tree via POST/PUT to root.
        
        if (writeJsonFile('team.json', $input)) {
            sendResponse($input);
        } else {
            sendError('Failed to save team data', 500);
        }
        break;

    case 'PUT':
        // Same as POST for this single-object structure
        if (writeJsonFile('team.json', $input)) {
            sendResponse($input);
        } else {
            sendError('Failed to save team data', 500);
        }
        break;

    default:
        sendError('Method not allowed', 405);
}
?>
