<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendError('Only POST method is allowed', 405);
}

// Check if file was uploaded
if (!isset($_FILES['file'])) {
    sendError('No file uploaded');
}

$file = $_FILES['file'];
$fileType = $file['type'];
$fileSize = $file['size'];
$fileName = $file['name'];
$fileTmpName = $file['tmp_name'];

// Validate file size
if ($fileSize > MAX_FILE_SIZE) {
    sendError('File size exceeds 10MB limit');
}

// Validate file type
$allowedTypes = array_merge(ALLOWED_IMAGE_TYPES, ALLOWED_DOC_TYPES);
if (!in_array($fileType, $allowedTypes)) {
    sendError('Invalid file type. Allowed: JPG, PNG, GIF, WebP, PDF, ZIP');
}

// Determine upload directory
$validTypes = ['documents', 'projects', 'images', 'blog'];
$requestedType = isset($_POST['type']) ? $_POST['type'] : '';

if (in_array($requestedType, $validTypes)) {
    $uploadSubDir = $requestedType;
} else {
    // Fallback based on file content type
    if (in_array($fileType, ALLOWED_IMAGE_TYPES)) {
        $uploadSubDir = 'images';
    } else {
        $uploadSubDir = 'documents';
    }
}

$uploadDir = UPLOAD_DIR . '/' . $uploadSubDir;

// Create directory if it doesn't exist
if (!file_exists($uploadDir)) {
    if (!mkdir($uploadDir, 0777, true)) {
        sendError('Failed to create upload directory: ' . $uploadSubDir, 500);
    }
}

// Generate unique filename
$extension = pathinfo($fileName, PATHINFO_EXTENSION);
$newFileName = uniqid() . '_' . time() . '.' . $extension;
$destination = $uploadDir . '/' . $newFileName;

// Move uploaded file
if (move_uploaded_file($fileTmpName, $destination)) {
    // Return the URL to access the file
    // Ensure URL uses forward slashes
    $fileUrl = '/api/uploads/' . $uploadSubDir . '/' . $newFileName;
    
    sendResponse([
        'success' => true,
        'url' => $fileUrl,
        'filename' => $newFileName,
        'originalName' => $fileName,
        'size' => $fileSize,
        'type' => $fileType
    ], 201);
} else {
    $error = error_get_last();
    sendError('Failed to upload file to server. Path: ' . $destination . '. Error: ' . ($error['message'] ?? 'Unknown error'), 500);
}
?>
