<?php
require_once 'config.php';

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

switch ($method) {
    case 'GET':
        $users = readJsonFile('users.json');
        
        if (isset($_GET['id'])) {
            $user = array_filter($users, fn($u) => $u['id'] === $_GET['id']);
            $user = array_values($user);
            sendResponse($user ? $user[0] : null);
        } else {
            sendResponse($users);
        }
        break;

    case 'POST':
        // Simple user creation (for admin use)
        $error = validateFields($input, ['name', 'email', 'role']);
        if ($error) sendError($error);

        $users = readJsonFile('users.json');
        $input['id'] = generateId('u');
        
        $users[] = $input;
        
        if (writeJsonFile('users.json', $users)) {
            sendResponse($input, 201);
        } else {
            sendError('Failed to create user', 500);
        }
        break;

    case 'PUT':
        if (!isset($input['id'])) sendError('User ID is required');
        
        $users = readJsonFile('users.json');
        $found = false;
        
        foreach ($users as $key => $user) {
            if ($user['id'] === $input['id']) {
                $users[$key] = array_merge($user, $input);
                $found = true;
                break;
            }
        }
        
        if (!$found) sendError('User not found', 404);
        
        if (writeJsonFile('users.json', $users)) {
            sendResponse($users[$key]);
        } else {
            sendError('Failed to update user', 500);
        }
        break;

    default:
        sendError('Method not allowed', 405);
}
?>
